/*
 * Decompiled with CFR 0.152.
 */
package dangerzone.particles;

import dangerzone.DangerZone;
import dangerzone.ModelBase;
import dangerzone.TextureMapper;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Particle {
    public double posx = 0.0;
    public double posy = 0.0;
    public double posz = 0.0;
    public int dimension = 0;
    public float rotation_yaw = 0.0f;
    public float rotation_pitch = 0.0f;
    public float rotation_roll = 0.0f;
    public float motionx = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.05f;
    public float motiony = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.05f;
    public float motionz = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 0.05f;
    public int maxrenderdist = 32;
    public String uniquename = null;
    public long lifetimeticker = 0L;
    public long maxlifetime = 30L;
    public float rotation_pitch_motion;
    public float rotation_yaw_motion;
    public float rotation_roll_motion;
    public String texturepath = null;
    public int tex = 0;
    public float brightness = 0.0f;
    public float scale = 0.25f;
    public float renderscale = 0.25f;
    public int bid = 0;
    public int iid = 0;
    public boolean fullsize = false;
    int once = 0;
    public ModelBase model;
    Texture texture = null;

    public Particle() {
        this.rotation_yaw = DangerZone.rand.nextInt(360);
        this.rotation_pitch = DangerZone.rand.nextInt(360);
        this.rotation_roll = DangerZone.rand.nextInt(360);
        this.rotation_yaw_motion = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 10.0f;
        this.rotation_pitch_motion = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 10.0f;
        this.rotation_roll_motion = (DangerZone.rand.nextFloat() - DangerZone.rand.nextFloat()) * 10.0f;
        this.tex = DangerZone.rand.nextInt(4);
        this.maxlifetime = 25 + DangerZone.rand.nextInt(10);
    }

    public void update(float deltaT) {
        ++this.lifetimeticker;
        this.posy += (double)(this.motiony * deltaT);
        this.posx += (double)(this.motionx * deltaT);
        this.posz += (double)(this.motionz * deltaT);
        this.rotation_pitch += this.rotation_pitch_motion * deltaT;
        this.rotation_yaw += this.rotation_yaw_motion * deltaT;
        this.rotation_roll += this.rotation_roll_motion * deltaT;
        while (this.rotation_yaw < 0.0f) {
            this.rotation_yaw += 360.0f;
        }
        this.rotation_yaw %= 360.0f;
        while (this.rotation_pitch < 0.0f) {
            this.rotation_pitch += 360.0f;
        }
        this.rotation_pitch %= 360.0f;
        while (this.rotation_roll < 0.0f) {
            this.rotation_roll += 360.0f;
        }
        this.rotation_roll %= 360.0f;
        this.renderscale = this.scale;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = this.bid == 0 && this.iid == 0 ? TextureMapper.getTexture(this.texturepath) : (this.iid != 0 ? Items.getTexture(this.iid) : Blocks.getTexture(this.bid));
        }
        return this.texture;
    }

    public int getSubTexture() {
        return this.tex;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public double getDistanceFromEntity(Entity p) {
        double d1 = p.posx - this.posx;
        double d2 = p.posy - this.posy;
        double d3 = p.posz - this.posz;
        return (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }
}

